


/******************************************************************************************
 *                                                                                        *
 * Ex1.      :   Read ASCII Code From Touch PAD Key 4x4 Out Hex Code To LED PortC	      *
 *               By Use Interupt Recive ASCII Code                                        *
 *               (Format:Press Single Key Only) 	                                      *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 *																				          *
 * Target MCU     : ATMEL AVR-MEGA128                                                      *
 *       	      : X-TAL : 16 MHz                                                        *
 *                                                                                        *
 * Editor         : AVR Studio 4.15 Build 623                                             *
 * Compiler       : WinAVR-20081205                                                       *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                  *
 * Last Update    : 09/September/2014                                                     *
 *																				          *
 * Port Interface :  -- MCU-AVR Mega 128--	  	  	      -- Key Touch PAD 4x4 --         *
 *                                                                                        *
 *       Uart0    :  PE0 = RXDO 	  Connect                 Tx of Board Touch Key       *  
 *                   PE1 = TXD0		  Connect                 Rx of Board Touch Key       * 												  *
 *                   Baud Rate = 9600 at Clock 16 Mhz                                     *
 *                                                                                        *
 *    LED DISPLAY : PC[0..7]	           Connect	              LED Common Anode 		  *
 *                                                                						  *  
 *                                                                             5V		  *
 *                                                                             -+- 		  *
 *                                                              560      \\     |  		  *
 *                                                       PC0 --/\/\/\-----|<|---+		  *
 *												 	             	 	 .	    |		  *
 *                                                              560      . \\   | 		  *
 *                                                       PC7 --/\/\/\-----|<|---+  		  *
 *																						  *
 *                                                                                        *
 *   Operation    : When Touch Key will Show Key Code(Hex of Ascii) on LED PORTC[0..7]    *
 *                                                                                        *
 *																						  *
 ******************************************************************************************/
 



#include <avr/io.h>                  //define port
#include <avr/interrupt.h>             //Interrupt Service routine
#include <stdio.h>
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit


#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)


volatile unsigned char key[3],n=0 ;
 

/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL, _FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);




//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
	  fputs("*ring*\n",stderr) ;
	  return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }



//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 104       ;     //Set Baud Rate 9600 : BURR= Fosc/[16x(9600)]-1
  
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter,enable Rx INT.
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
  
   sei()              ;     //Set Global Interrupt enable 
   
   stdout = &uart_str ;     //Set address uart_str to stdout/stdin

   
 }


//****** Interrupt Service Receive DATA UART0 (RX0) ******
//********************************************************
   
ISR (USART0_RX_vect) 
   {

		 key[n] = UDR0                 ;  //Step1: Read ASCII Code 3 Byte
		 		   
		 n++                           ;  //Pointer Array	  

		 if(n == 3)			              //if Pointer= 3 Clear Pointer=0
		   n=0                         ;
	 

   }	
   
   
   
   
    

//*************************** Main *************************


 int main (void) 
  {
    //---------------Initial Port I/O ----------------

   DDRC  = 0xFF     ;        //Set PC0..PC7 = Output for Display Key Code
    
   PORTC = 0xFF     ;        //Set Default data PortC = LED OFF        

   UART0_Init()     ;        //Initial Uart0
 


    while(1) 
	 {   

	    if(key[2] == 0x0D)             //Step2: Check data Last Byte readded              
	    {
	
	       key[2] =0 ;	               //Step3: Clear data in buffer array key[2]
			
		   if(key[0]=='P')		       //Step4: Check  Status  Pressed key (ASCII Code = 'P')
		    {
               //------ Step5 : Write Program Support Touch Single Key of User ------ 
		                
		 	   PORTC = ~key[1]         ;      //Out data key Hex Code to LED PC[0..7]
               
               while(key[0] != 'R') {;}       //wait Release Key (when key[0]=R) for Exit Loop   
			   
			   PORTC = 0xFF            ;      //Clear LED PORT PC = OFF            

		    }
	    }  //if key[2] =0x0D  	 

	 }

  }



  


